/*
   -- Bluetooth_control --
   
   This source code of graphical user interface 
   has been generated automatically by RemoteXY editor.
   To compile this code using RemoteXY library 2.3.3 or later version 
   download by link http://remotexy.com/en/library/
   To connect using RemoteXY mobile app by link http://remotexy.com/en/download/                   
     - for ANDROID 4.1.1 or later version;
     - for iOS 1.2.1 or later version;
    
   This source code is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.    
*/

//////////////////////////////////////////////
//        RemoteXY include library          //
//////////////////////////////////////////////

// RemoteXY select connection mode and include library 
#define REMOTEXY_MODE__SOFTSERIAL
#include <SoftwareSerial.h>

#include <RemoteXY.h>

// RemoteXY connection settings 
#define REMOTEXY_SERIAL_RX 11
#define REMOTEXY_SERIAL_TX 12
#define REMOTEXY_SERIAL_SPEED 9600


// RemoteXY configurate  
#pragma pack(push, 1)
uint8_t RemoteXY_CONF[] =
  { 255,4,0,0,0,53,0,8,13,0,
  1,1,43,12,13,13,2,31,0,1,
  1,30,25,13,13,2,31,0,1,1,
  56,25,13,13,2,31,0,1,1,43,
  38,13,13,2,31,0,129,0,72,46,
  20,6,17,121,111,98,111,116,115,0 };
  
// this structure defines all the variables of your control interface 
struct {

    // input variable
  uint8_t fbutton; // =1 if button pressed, else =0 
  uint8_t lbutton; // =1 if button pressed, else =0 
  uint8_t rbutton; // =1 if button pressed, else =0 
  uint8_t bbutton; // =1 if button pressed, else =0 

    // other variable
  uint8_t connect_flag;  // =1 if wire connected, else =0 

} RemoteXY;
#pragma pack(pop)


/////////////////////////////////////////////
//           END RemoteXY include          //
/////////////////////////////////////////////

/////////////////////////////////////////////
//          Define your motor pins         //
/////////////////////////////////////////////

#define lm1 2 //lm1=left motor 1
#define lm2 3
#define rm1 4
#define rm2 5


void setup() 
{
  RemoteXY_Init (); 
  pinMode(lm1,OUTPUT);
  pinMode(lm2,OUTPUT);
  pinMode(rm1,OUTPUT);
  pinMode(rm2,OUTPUT);
  
  
  // TODO you setup code
  
}

void loop() 
{ 
  RemoteXY_Handler ();
  if (RemoteXY.fbutton == 1)
  {
    forward();
  }
  else  if (RemoteXY.bbutton == 1)
  {
    backward();
  }
  else  if (RemoteXY.lbutton == 1)
  {
    left();
  }
   else if (RemoteXY.rbutton == 1)
  {
    right();
  }
  else
  {
    stop_motor();
  }
  
  // TODO you loop code
  // use the RemoteXY structure for data transfer


}


/////////////////////////////////////////////////////////////////////////////
//   Define these function as per your pin configuration with motor driver//
////////////////////////////////////////////////////////////////////////////

void forward()
{
  digitalWrite(lm1, HIGH);
  digitalWrite(lm2, LOW);
  digitalWrite(rm1, HIGH);
  digitalWrite(rm2, LOW);
}

void backward()
{
  digitalWrite(lm1, LOW);
  digitalWrite(lm2, HIGH);
  digitalWrite(rm1, LOW);
  digitalWrite(rm2, HIGH);
}

void left()
{
  digitalWrite(lm1, LOW);
  digitalWrite(lm2, HIGH);
  digitalWrite(rm1, HIGH);
  digitalWrite(rm2, LOW);
}

void right()
{
  digitalWrite(lm1, HIGH);
  digitalWrite(lm2, LOW);
  digitalWrite(rm1, LOW);
  digitalWrite(rm2, HIGH);
}

void stop_motor
()
{
  digitalWrite(lm1, LOW);
  digitalWrite(lm2, LOW);
  digitalWrite(rm1, LOW);
  digitalWrite(rm2, LOW);
}



